<?LassoScript
	
	// Lasso Example Pack
	// Poll Example
	// Display JavaScript
	// Copyright  2005 OmniPilot Software, Inc.
	
	// This file should be included in a Web page using <script src="poll.lasso" />

	var: 'poll_prefs' = (map:
		'display_height' = 'auto',
		'display_width' = '288px',
		'display_background' = 'black',
		'display_color' = 'silver',
		'display_fontfamily' = 'Verdana',
		'display_fontsize' = '10px',
		'display_title_background' = 'green',
		'display_title_color' = 'silver',
		'display_title_fontfamily' = 'Verdana',
		'display_title_fontsize' = '14px',
		'display_graph_color' = 'silver',
	);
	
	// For debugging the log level can be modified to sql
	var: 'log_level' = 'none';
	
	var: 'poll' = (action_param: 'poll', (action_param: 'poll', -count));
	var: 'action' = (action_param: 'action', (action_param: 'action', -count));
	var: 'mode' = (action_param: 'mode', (action_param: 'mode', -count));
	var: 'key' = (action_param: 'key', (action_param: 'key', -count));
	var: 'answer' = (action_param: 'answer', (action_param: 'answer', -count));
	
	var: 'inline' = (array);
	if: (admin_currentgroups !>> 'administrators') && (admin_currentgroups !>> 'OP Poll Admins');
		$inline->(insert: -op='eq');
		$inline->(insert: 'status'='true');
	/if;
	if: ($poll == '');
		$inline->(insert: -op='eq');
		$inline->(insert: 'current'='true');
	else;
		$inline->(insert: -op='eq');
		$inline->(insert: 'code'=$poll);
	/if;
	
	inline: -log=$log_level, 
			-search,
			-database='op_quick_poll', 
			-table='polls', 
			-maxrecords=1, -uselimit,
			$inline,
			-sortfield='id', -sortorder='descending';
		var: 'poll_id' = (field: 'id');
		if: (found_count > 0);
			var: 'poll_title' = (field: 'title');
			var: 'poll_code' = (field: 'code');
			var: 'poll_question' = (field: 'question');
			var: 'poll_results' = (field: 'results');
			var: 'poll_display' = (field: 'display');
			var: 'poll_status' = (field: 'status');
			var: 'poll_archive' = (field: 'archive');
			var: 'poll_current' = (field: 'current');
			var: 'poll_frequency' = (field: 'frequency');
			if: ((field: 'prefs') != null) && (field: 'prefs')->(beginswith: '<map');
				var: 'temp' = map;
				$temp->(deserialize: (field: 'prefs'));
				$poll_prefs->(insertfrom: $temp->iterator);
			/if;
		/if;
	/inline;				

	if: ($poll_id == '');
		// No Poll Was Found
		var: 'output' = '<h2>No Poll Was Found</h2>';
	else: ($action >> 'Submit') || ($poll_archive == 'true') || ($action >> 'View');
		// Display Results
		if: ($poll_archive == 'true');
			var: 'message' = 'Voting in this poll has finished.';
		else: ($action >> 'Submit');
			// Casting a Vote
		
			var: 'already_voted' = false;
			var: 'client_address' = (string: client_address);

			var: 'inline' = (array);
			$inline->(insert: -op='eq');
			$inline->(insert: 'poll_id' = $poll_id);
			if: $poll_frequency >> 'once';
				$inline->(insert: -op='eq');
				$inline->(insert: 'ipaddress' = client_address);
			else: $poll_frequency >> 'hour';
				$inline->(insert: -op='eq');
				$inline->(insert: 'ipaddress' = client_address);
				$inline->(insert: -op='bw');
				$inline->(insert: 'datetime' = date->(format: '%Q %H'));
			else: $poll_frequency >> 'month';
				$inline->(insert: -op='eq');
				$inline->(insert: 'ipaddress' = client_address);
				$inline->(insert: -op='bw');
				$inline->(insert: 'datetime' = date->(format: '%Y-%m'));
			else;
				$inline->(insert: -op='eq');
				$inline->(insert: 'ipaddress' = $client_address);
				$inline->(insert: -op='bw');
				$inline->(insert: 'datetime' = date->(format: '%Q'));
			/if;
		
			inline: -log=$log_level, 
					-search,
					-database='op_quick_poll', 
					-table='results',
					-keyfield='id',
					$inline,
					-maxrecords=1, -uselimit,
					-returnfield='id';
				if: (found_count == 1);
					var: 'already_voted' = true;
				/if;
			/inline;
									
			if: $already_voted == false;
				inline: -log=$log_level, 
						-add,
						-database='op_quick_poll', 
						-table='results',
						-keyfield='id',
						'answer_id' = $answer,
						'poll_id' = $poll_id,
						'datetime' = date->(format: '%Q %T'),
						'ipaddress' = $client_address,
						-maxrecords=0;
				/inline;
				inline: -log=$log_level, 
						-search,
						-database='op_quick_poll', 
						-table='results',
						-keyfield='id',
						-op='eq', 'answer_id' = $answer,
						-op='eq', 'poll_id' = $poll_id,
						-maxrecords='1',
						-returnfield='id';
					if: (found_count > 0);
						inline: -log=$log_level, 
								-update,
								-database='op_quick_poll', 
								-table='answers',
								-keyfield='id',
								-keyvalue=$answer,
								'result'=(found_count),
								-maxrecords=0;
						/inline;
					/if;
				/inline;
				
				var: 'message' = 'Thank you for participating in our poll.';
			else;
				var: 'message' = 'Your vote in this poll has already been recorded.';
			/if;
		else;
			var: 'message' = 'These are the results of the poll so far.';
		/if;
		
		// The blank image should be located in the same folder as this file
		var: 'image_src' = (response_filepath - 'poll.lasso' + '1x1.gif');

		var: 'output' = (include: (var: 'path') + 'result.lasso');

	else;
		// Display Question
		
		var: 'key' = lasso_uniqueid;
		var: 'output' = (include: (var: 'path') + 'display.lasso');
	/if;

	if: ($mode >> 'html');
		'<html>\r\n';
		'\t<head>\r\n';
		'\t\t<title>' + $poll_title + '</title>\r\n';
		'\t</head>\r\n';
		'\t<body>\r\n';
		$output; '\r\n';
		'\t</body>\r\n';
		'</html>';
	else;
		$output = (string_replace: $output, -find='\'', -replace='\\\'');
		$output = (string_replace: $output, -find='\r', -replace='\\r');
		$output = (string_replace: $output, -find='\n', -replace='\\n');
		$output = (string_replace: $output, -find='\t', -replace='\\t');
		include: (var: 'path') + 'javascript.lasso';
		'\r\n';
		'document.write(\'' + $output + '\');\r\n';	
	/if;
	
?>


